import React, {useMemo, Component} from 'react';
import {List, Picker} from 'antd-mobile';
import styles from './styles.less';

const getItemChildren = (childrenList, parent) => {
  if (!childrenList || !childrenList.length) {
    return [];
  }
  for (let item of childrenList) {
    if (item.label.indexOf(parent.label) > -1) {
      item.label = item.label.replace(parent.label, '');
    }
    for (let proviceName of ['内蒙古', '广西', '新疆', '香港', '澳门', '西藏', '宁夏']) {
      item.label = item.label.replace(proviceName, '');
    }
    if (item.children) {
      item.children = getItemChildren(item.children, parent);
    }
  }
  return childrenList;
}

export default class MobileCascader extends Component{
  constructor(props) {
    super(props);
  }
  render() {
    const {onChange, options, label, disabled, value, json, otherProps} = this.props;
    let opt = options &&
      Array.isArray(options) &&
      options.map((x) => {
        return {
          label: x.label,
          value: x.value,
          children: getItemChildren(x.children, x),
        };
      });
    return (
      <div className={styles.mobileFormInput}>
        <Picker
          data={opt || []}
          cascade={true}
          // cols={1}
          disabled={disabled}
          value={value}
          extra={disabled ? '' : json.placeholder || '点击选择'}
          onChange={(val) => {
            onChange(val || undefined);
          }}
          {...otherProps?.props}
        >
          <List.Item arrow={disabled ? '' : 'horizontal'}>
            {/*{label}*/}
          </List.Item>
        </Picker>
      </div>
    );
  }
}
//
//
// export default function MobileCascader(props) { // 级联选择
//
// }
