import React, { useMemo } from 'react';
import ReactEcharts from 'echarts-for-react';

export default function EchartsDiy(props){
  const { json, uuid, option, value } = props;
  const opt = useMemo(() => {
    return (value && typeof value === 'object' && Object.keys(value).length) ? value : option;
  }, [value, option]);
  // console.log(opt);
  if(!opt){
    return null;
  }
  return (
    <ReactEcharts
      style={{ height: json.height || 500 }}
      key={uuid}
      option={opt}
      notMerge={true}
      lazyUpdate={true}
      theme={'theme_name'}
      onEvents={{}}
    />
  )
}
