import React, { Fragment, useEffect, useRef } from 'react';
import { WhiteSpace, WingBlank } from 'antd-mobile';

export default function MobileCard(props) {
  const { value = {}, onChange, json, getArguments, tableComProps, dataColumn } = props;
  let otherProps = {};
  if (json?.otherProps) {
    otherProps = json?.otherProps;
    try {
      let arg = {};
      if (typeof getArguments === 'function') {
        arg = getArguments({ base52: dataColumn.base52 }, function() {});
      }
      otherProps = new Function('functionArguments', 'tableComProps', otherProps)(
        arg,
        tableComProps,
      );
    } catch (e) {
      console.log('MobileCard组件获取otherProps 报错', e);
      otherProps = null;
    }
  }
  if (!otherProps) {
    return null;
  }
  const dataSource = value?.dataSource || otherProps?.defaultDataSource || [];
  const { columns = [], primaryKey = '', style = {}, handleClick, emptyDataInfo } = otherProps;
  return (
    <>
      {dataSource.map((g, index) => {
        const clickFunction =  // 点击整个块
          typeof handleClick === 'function'
            ? e => {
              if (e && e.stopPropagation) {
                e.stopPropagation();
                e.preventDefault();
              }
              handleClick(g,value);
            }
            : undefined;
        return (
          <div key={g[primaryKey]} style={style} onClick={clickFunction}>
            <WingBlank>
              {columns.map((c, cIndex) => {
                const { style: cStyle, data: cData } = c;
                const clickOneRow = // 点击某一行
                  typeof c.handleClick === 'function'
                    ? e => {
                      if (e && e.stopPropagation) {
                        e.stopPropagation();
                        e.preventDefault();
                      }
                      return c.handleClick(g, c, value);
                    }
                    : undefined;
                return (
                  <div key={c.key} style={cStyle || {}} onClick={clickOneRow}>
                    {cData.map((h, hIndex) => {
                      let hProps = h.props || {};
                      const clickOneCell = // 点击某一个单元格
                        typeof h.handleClick === 'function'
                          ? e => {
                              if (e && e.stopPropagation) {
                                e.stopPropagation();
                                e.preventDefault();
                              }
                              return h.handleClick(g, h.key || h, value);
                            }
                          : undefined;
                      if (h.diyProps && typeof h.diyProps === 'function') {
                        hProps = h.diyProps(g, h.key || h, value) || {};
                      }
                      return (
                        <div style={hProps.style} onClick={clickOneCell} key={h.key || h.value}>
                          {hProps.children ? (
                            <>{hProps.children}</>
                          ) : (
                            <>
                              {h.type === 'dataIndex' && index + 1}
                              {(h.type === 'dataSource' && g[h.key]) || ''}
                              {h.type === 'chinese' && h.value}
                            </>
                          )}
                        </div>
                      );
                    })}
                  </div>
                );
              })}
            </WingBlank>
          </div>
        );
      })}
      {  // 没有数据的时候显示提示文字
        (!Array.isArray(dataSource) || !dataSource.length) && !!emptyDataInfo &&
          <div style={emptyDataInfo.style || {}}>
            {emptyDataInfo.children}
          </div>
      }


    </>
  );
}
