import moment from 'moment';
import { DatePicker } from 'antd';

const { RangePicker } = DatePicker;
import React, { useEffect, useState } from 'react';
import getPopupContainer
  from '@/webPublic/one_stop_public/tableCompon/Split_Index/getPopupContainer';

export function getMomentArr({
                               begin,
                               end,
                               initValue,
                               init,
                               obj,
                             }) {
  let ivs = [];
  if (initValue != null && init != null) {
    ivs.push(moment(parseInt(initValue)));
    if (init && init[end.base52]) {
      ivs.push(moment(parseInt(init[end.base52])));
    } else if (obj && obj[end.base52]) {
      ivs.push(moment(parseInt(obj[end.base52])));
      // 钟是志 2021年9月28日13:59:48
      // 禅道bug http://scjoyedu.eicp.net:88/zentao/bug-view-21843.html
      // 不知道怎么改 init 为空对象 暂时处理为从obj里面拿
    } else {
      ivs.push(moment());
    }
  }

  if (!ivs || !Array.isArray(ivs) || ivs.length !== 2) {
    ivs = [];
  } else {
    for (let i = 0; i < ivs.length; i++) {
      if (!moment.isMoment(ivs[i])) {
        ivs[i] = moment();
      }
    }
  }
  return ivs;
}

export default function RangePickerDiy(props) {
  const {
    onChange,
    value,
    json,
    disabled,
    uuid,
  } = props;
  const [bindValue, setBindValue] = useState([]);

  useEffect(() => {
    if (!value || !Array.isArray(value) || value.length !== 2) {
      setBindValue([]);

    } else {
      for (let i = 0; i < value.length; i++) {
        if (typeof value[i] === 'number' && value[i] > 10000) {
          bindValue[i] = moment(value[i]);
        } else if (!moment.isMoment(value[i])) {
        } else {
          bindValue[i] = value[i];
        }
      }
      setBindValue(value);
    }
  }, [value]);

  function handleChange(v){
    onChange(v);
  }

  return (
    <RangePicker
      value={bindValue}
      onChange={handleChange}
      showTime={json.showTime != null ? json.showTime : true}
      format={json.format ? json.format : 'YYYY-MM-DD HH:mm:ss'}
      disabled={disabled}
      getCalendarContainer={getPopupContainer(false, uuid)}
    />
  );

}
