export default function giveVarcharRules({
                                           dataColumn = {},
                                           json = {},
                                           required = false,
                                           title = '',
                                         }) {
  const res =
    Array.isArray(json.vlds) && json.vlds.length > 0
      ? json.vlds
      : [
        {
          required: required,
          message: '请输入' + title,
        },
      ];
  if (dataColumn?.type === 'VARCHAR' && dataColumn.length && res.length < 2) {
    // console.log(dataColumn.length);
    res.push({
      max: dataColumn.length,
      message: `不能超过${dataColumn.length}个字符`,
      transform: function(value){
        return value + '';
      },
    });
  }
  return res;
}
