import { message } from 'antd';
import baseX from 'base-x';
import moment from 'moment';
import { isNaN } from 'lodash';
import React from 'react';
import config from '@/webPublic/one_stop_public/config';
import { isJSON } from '@/webPublic/one_stop_public/2022beidianke/isJSON';
import { queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';

const codeMessage = {
  200: '服务器成功返回请求的数据。',
  201: '新建或修改数据成功。',
  202: '一个请求已经进入后台排队（异步任务）。',
  204: '删除数据成功。',
  400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
  401: '登录已过期，请重新登录',
  403: '用户得到授权，但是访问是被禁止的。',
  404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
  406: '请求的格式不可得。',
  410: '请求的资源被永久删除，且不会再得到的。',
  422: '当创建一个对象时，发生一个验证错误。',
  500: '服务器发生错误，请检查服务器。',
  502: '网关错误。',
  503: '服务不可用，服务器暂时过载或维护。',
  504: '网关超时。',
};


const errorHandler = (error) => {
  const { response } = error;
  if (response && response.status) {
    const errorText = codeMessage[response.status] || response.statusText;
    message.error(`请求错误${errorText}`);
    if (response.status === 401) {
      return window.g_app._store.dispatch({
        type: 'login/loginout',
      });
    }
  } else {
    message.error(`网络故障,请检查网络链接或联系管理员`);
  }
};

const Bs64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
const base64 = baseX(Bs64);

export function getBase64(value) {
  return value ? base64.encode(new Buffer(value)) : null;
}


const equal = (obj1, obj2, json, sqlContent, depth, props, excludeKeys) => {
  if (obj1 == null && obj2 != null) {
    return false;
  }
  if (obj1 != null && obj2 == null) {
    return false;
  }
  if (obj1 == null && obj2 == null) {
    return true;
  }

  if (obj1 instanceof Date) {
    if (obj1.valueOf() != obj2.valueOf()) {
      return false;
    }
  } else if (obj1 instanceof moment) {
    if (obj1.valueOf() != obj2.valueOf()) {
      return false;
    }
  } else if (typeof obj1 == 'function') {
    if (obj1.toString() != obj2.toString()) {
      return false;
    }
  }

  const keys = new Set();
  if (obj2 != null) {
    Object.keys(obj2)
      .forEach(k => {
        if (k != '') keys.add(k);
      });
  }
  if (obj1 != null) {
    Object.keys(obj1)
      .forEach(k => {
        if (k != '') keys.add(k);
      });
  }

  let res = true;

  for (let key of keys) {
    if (key == '') {
      continue;
    }

    if (excludeKeys.includes(key)) {
      continue;
    }

    if (obj1[key] == null && obj2[key] != null) {
      res = false;
      break;
    }
    if (obj1[key] != null && obj2[key] == null) {
      res = false;
      break;
    }

    if (
      depth == 1 &&
      ((props.json.sqlKey == null &&
          sqlContent == null &&
          json.formula == null &&
          json.funcs == null) ||
        (sqlContent != null && sqlContent.indexOf(key) == -1) ||
        (json.formula != null &&
          json.formula.indexOf(key) == -1 &&
          json.funcs != null &&
          json.funcs.indexOf(key) == -1))
    ) {
      excludeKeys.push(key);

      continue;
    }

    if (obj1[key] == null && obj2[key] == null) {
      continue;
    }
    if (isNaN(obj1[key]) && isNaN(obj2[key])) {
      continue;
    }

    if (obj1[key] instanceof Array) {
      if (obj1[key].length != obj2[key].length) {
        res = false;
        break;
      } else {
        var xx = true;

        for (var i = 0; i < obj1[key].length; i++) {
          if (!equal(obj1[key][i], obj2[key][i], json, sqlContent, depth + 1, props, excludeKeys)) {
            xx = false;
            break;
          }
        }

        if (!xx) {
          res = false;
          break;
        }
      }
    } else if (obj1[key] instanceof Object) {
      const x = equal(obj1[key], obj2[key], json, sqlContent, depth + 1, props, excludeKeys);

      if (!x) {
        res = false;
        break;
      }
    } else if (typeof obj1[key] == 'function') {
      if (obj1[key].toString() != obj2[key].toString()) {
        res = false;
        break;
      }
    } else {
      if (obj1[key] != obj2[key]) {
        res = false;
        break;
      }
    }
  }

  return res;
};

const getRender = (com, props) => {
  if (com == 'p') return <p {...props} />;
  if (com == 'ul') return <ul {...props} />;
  if (com == 'li') return <li {...props} />;
  if (com == 'video') return <video {...props} />;
  if (com == 'span') return <span {...props} />;
  if (com == 'a') return <a {...props} />;
  if (com == 'div') return <div {...props} />;
  if (com == 'canvas') return <canvas {...props} />;
  if (com == 'iframe') return <iframe {...props} />;
  if (com == 'img') {
    const src = queryFileUrl(props.src)
    const pp = {
      ...props,
      src: src
    };
    return <img {...pp} />;
  }
};



const ShowComName = ({ json = {} }) => <span
  style={{ display: 'none' }}
  data-cell-component-name={json.comName || 'no_com'}
/>;

export { errorHandler, equal, getRender, isJSON, ShowComName };
