/**
 * 将接口数据进行缓存, 节流接口让页面没有那么卡顿
 * 钟是志
 * 2022年12月8日
 * */

window.onestopApiServiceCacheData = {};

const cacheApiconfig = [
	{
		key: 'findParamsKey', // 接口唯一的键
		url: '/SqlManageEntityApi/findParamsKey', // 接口地址
		searchParams: 'sqlKey', // 缓存的参数
		time: 600, // 缓存数据有效期.  单位秒
	},
	{
		key: 'find', // 接口唯一的键
		url: '/SqlManageEntityApi/find', // 接口地址
		searchParams: 'sqlKey', // 缓存的参数
		time: 600, // 缓存数据有效期.  单位秒
	},
	{
		key: 'getSqlOptions', // 接口唯一的键
		url: '/DataColumnApi/getSqlOptions', // 接口地址
		searchParams: 'sqlKey', // 缓存的参数
		otherParams: 'allValues',
		time: 1, // 缓存数据有效期.  单位秒
	},
  {
    key: 'getSqlData', // 接口唯一的键
    url: '/DataColumnApi/getSqlData', // 接口地址
    searchParams: 'sqlKey', // 缓存的参数
    // otherParams: 'allValues,jsParams,pageSize,pageNum',
   // otherParamsArray: ['allValues','jsParams','pageSize','pageNum'],
    time: 600, // 缓存数据有效期.  单位秒
    isCache: true,
  },
];

function getConfig(apiUrl, params) {
	let findConfig = cacheApiconfig.find((g) => {
	  if(apiUrl === g.url){
	    if(g.isCache){
	      if(params.isCache){
	        return true;
        }else{
	        return false;
        }
      }
	    return true;
    }
	  return  false;
	});
	return findConfig || undefined;
}

// 获取缓存数据
export function getCacheData(apiUrl, params) {
	return new Promise((resolve, reject) => {
		let findConfig = getConfig(apiUrl, params);
		if (!findConfig) {
			resolve(false);
			return;
		}
		let res = window.onestopApiServiceCacheData[findConfig.key + params[findConfig.searchParams]];
		if (!res ||
      new Date().getTime() > res?.expiresTime ||
      (params[findConfig.otherParams] && params[findConfig.otherParams] !== res.otherParams)
    ) {
			window.onestopApiServiceCacheData[findConfig.key + params[findConfig.searchParams]] =
				'pending';
			resolve(false);
			return;
		}
		if (res === 'pending') {
			let interval = setInterval(() => {
				let newD =
					window.onestopApiServiceCacheData[findConfig.key + params[findConfig.searchParams]];
				if (newD !== 'pending') {
					clearInterval(interval);
					resolve(newD.response);
					return newD.response;
				}
			}, 200);
		} else {
			resolve(res.response);
			return res.response;
		}
	});
}

// 保存缓存数据
export function saveCacheData(apiUrl = '', params, response = {}) {
	let findConfig = getConfig(apiUrl, params);
	if (findConfig) {
		// console.log(params);
		window.onestopApiServiceCacheData[findConfig.key + params[findConfig.searchParams]] = {
			response,
			expiresTime: new Date().getTime() + findConfig.time * 1000,
			otherParams: params[findConfig.otherParams] || undefined, // 接口参数做缓存
		};
		// console.log(window.onestopApiServiceCacheData);
		return true;
	} else {
		return false;
	}
}
