/**
 * @param key 配置文件中 key
 * @author yyq
 * @version 0.0.1
 * @return 配置信息
 * @description
 * 当未传入key时返回config对象
 * 当key存在是且存在对应key值时返回key值 否则返回config对象
 * */

//请求地址前缀

if (typeof globalThis === 'undefined') { // globalThis 在qq浏览器存在兼容性问题 https://caniuse.com/?search=globalThis
  var globalThis = window;
}

if (!globalThis.CONFIG) {
  alert('系统错误,请联系管理员');
  // return;
  // var SERVER_PATH =  window.location.origin + '/produce/v1/api/onestop';
  // var ACTION_PATH = SERVER_PATH + '';
  // globalThis.CONFIG = {
  //   SYSCODE: 'code',
  //   OAUTH_ACTION_PATH: ACTION_PATH + '',                                    //服务请求地址
  //   PERM_ACTION_PATH: ACTION_PATH + '',                                        //服务请求地址
  //   API_ACTION_PATH: ACTION_PATH + '',                                     //服务请求地址
  //   FILE_UPLOAD_ACTION_PATH: ACTION_PATH + '/folder/uploadFileApi/upload',          //文件上传地址
  //   LAYOUT_HEADER_LOGO: 'default_layoutHeader_logo.png',                            //layout 系统logo
  //   LOGIN_HEADER_LOGO: 'default_layoutHeader_logo2.png',                                                          //登录页面头部logo
  //   SYSTEM_NAME: '一站式事物管理系统',                                                        //系统名称
  //   LAYOUT_HEADER_SYSTEM_WELCOME: '',               //layout头部系统欢迎语
  //   LAYOUT_TYPE: 'ZY',                                                              //使用Layout内省       ANT | ZY  分别为ant-pro自带layout和知用layout
  //   LAYOUT_HEADER_CENTER_BACKGROUND: 'lsz.png',                                     //layout头部中间背景图片
  //   LAYOUT_SIDER_FOOTER_BACKGROUND: 'lsz2.png',                                     //layout菜单底部背景图片
  //   LOGIN_BACKGROUND: 'logoPic_gyys.png',                                                 //layout菜单底部背景图片
  //   CHECK_PATH: true,                                                              //layout菜单底部背景图片
  //   LOGIN_REDIRECT: '/portal/home',                                                          //登录后重定向地址
  //   WS_PATH: null,
  //   DYNAMIC_ACTION_PATH: ACTION_PATH,
  // };
}

const queryConfig = (key) => {
  const dynamicConfig = typeof globalThis !== 'undefined' ? globalThis.CONFIG : window.CONFIG;
  if (typeof key === 'undefined') return dynamicConfig;
  return dynamicConfig[key];
};

/**
 * @description 获取系统编码
 * */
export const querySysCode = () => queryConfig('SYSCODE');

export const queryWsPath = () => queryConfig('WS_PATH');

/**
 * @description 获取场景设计器定制后台地址
 * */
export const queryDynamicActionPath = () => queryConfig('DYNAMIC_ACTION_PATH');

/**
 * @description 获取服务端请求路径前戳
 * */
export const queryOauthActionPath = () => queryConfig('OAUTH_ACTION_PATH');

/**
 * @description 获取服务端请求路径前戳
 * */
export const queryPermActionPath = () => queryConfig('PERM_ACTION_PATH');

/**
 * @description 获取服务端请求路径前戳
 * */
export const queryApiActionPath = () => queryConfig('API_ACTION_PATH');

/**
 * @description 获取文件上传地址
 * */
export const queryFileUploadActionPath = () => queryConfig('FILE_UPLOAD_ACTION_PATH');

/**
 * @description 获取layout头部logo名称
 * */
export const queryLayoutHeaderLogo = () => queryConfig('LAYOUT_HEADER_LOGO');

/**
 * @description 获取登录页面头部logo名称
 * */
export const queryLoginHeaderLogo = () => queryConfig('LOGIN_HEADER_LOGO');

/**
 * @description 获取系统名称
 * */
export const querySystemName = () => queryConfig('SYSTEM_NAME');

/**
 * @description 获取layout头部系统欢迎语
 * */
export const queryLayoutHeaderSystemWelcome = () => queryConfig('LAYOUT_HEADER_SYSTEM_WELCOME');

/**
 * @description 获取layout类型
 * */
export const queryLayoutType = () => queryConfig('LAYOUT_TYPE');

/**
 * @description 获取layout头部中间背景图片
 * */
export const queryLayoutHeaderCenterBackground = () =>
  queryConfig('LAYOUT_HEADER_CENTER_BACKGROUND');

/**
 * @description 获取layout菜单底部背景图片
 * */
export const queryLayoutSiderFooterBackground = () => queryConfig('LAYOUT_SIDER_FOOTER_BACKGROUND');

/**
 * @description 获取登录页面登录框旁背景图片
 * */
export const queryLoginBackground = () => queryConfig('LOGIN_BACKGROUND');

/**
 * @description 获取动态图片前缀
 * */
export const queryDynamicImagePrefix = () => `${window.publicPath}images/dynamic/`;

/**
 * @description 获取配置项路由是否需要权限控制
 * */
export const queryCheckPath = () => queryConfig('CHECK_PATH');

/**
 * @description 获取配置项路由是否需要权限控制
 * */
export const queryLoginRedirect = () => queryConfig('LOGIN_REDIRECT');
export const queryApiVersion = () => queryConfig('apiVersion');
export const queryUiaApi = () => queryConfig('oauthServer');
export const queryIsSafe = () => queryConfig('IS_SAFE'); // 是否开启文件上传加密 2022年5月24日 钟是志 解决北电科安全防火墙bug
export const queryIsBinary = () => queryConfig('IS_BINARY'); // 是否开启接口加密二进制上传 2022年6月9日 钟是志 解决北电科安全测评 27448
export const resetLoginUrl = () => queryConfig('resetLoginUrl'); // 是否退出登录注销token 解决北电科安全测评
export const hiddenExitButton = () => queryConfig('hiddenExitButton');

export const queryFileUrl = (url = '', defaultFile = '') => {
  if (url && typeof url === 'string' && url.length > 10) {
    if (url.indexOf('http') > -1) {
      return url;
    }
    const prefix = window.CONFIG['FILE_PATH'] || window.CONFIG['API_ACTION_PATH'];
    return prefix + url;
  } else {
    if (defaultFile) {
      return defaultFile;
    }
    return '';
  }
};

export function fileUrlToFilePath(url) {
  const prefix = window.CONFIG['FILE_PATH'] || window.CONFIG['API_ACTION_PATH'];
  if(url && typeof url === 'string' && url.includes(prefix)){
    return url.replace(prefix, '');
  }
}

export default queryConfig;
