import { message } from 'antd';
import { ModalConfirm, ModalInfo } from '@/baseComponent/Modal';
import * as lo from './LodopFuncs';

export const A4Height = '29.7cm';
export const A4Width = '21cm';
export const imageStyleAll = {
	width: '100%',
	// height: '100%',
};

export const defaultConfigInfo = {
	paperHeight: A4Height,
	paperWidth: A4Width,
};

export const defaultItemConfigInfo = {
	textStyle: {},
};

export function getCLodopFuncJS() {
	return new Promise((resolve, reject) => {
		resolve(true);
	});

	return new Promise((resolve, reject) => {
		if (window.LODOP) {
			console.log('打印插件加载成功');
			resolve(true);
			return true;
		}
		let sc = document.createElement('script');
		if (window.location.protocol === 'http:') {
			sc.src = `http://localhost:18000/CLodopFuncs.js`;
		} else {
			sc.src = `https://localhost:8443/CLodopFuncs.js`;
		}
		document.querySelector('body').appendChild(sc);
		sc.onload = function() {
			resolve(true);
			console.log('打印插件加载成功');
		};
		sc.onerror = function() {
			resolve(false);
			ModalConfirm('请下载并运行打印控件后刷新本页面继续打印！' + '点击确定进行控件下载', {
				title: '未获取到打印控件',
				onOk: () => {
					window.open(window.location.origin + '/zyd/CLodop_32_Print.zip');
				},
			});
		};
	});
}

export const fieldTypeList = [
	{
		key: '-2',
		name: '条形码',
	},
	{
		key: '-1',
		name: '常量',
	},
	{
		key: '0',
		name: '文字',
	},
	{
		key: '1',
		name: '时间',
	},
	{
		key: '2',
		name: '照片',
	},
];

export const fontFamilyList = [
	{
		key: '宋体',
		name: '宋体',
	},
	{
		key: '楷体',
		name: '楷体',
	},
	{
		key: '黑体',
		name: '黑体',
	},
	{
		key: '隶书',
		name: '隶书',
	},
	{
		key: '微软雅黑',
		name: '微软雅黑',
	},
];

export const styleCount = (config) => {
	const style = {
		fontSize: `${config.fieldFontSize || 16}px`, // 默认 16px
		fontFamily: `${config.fieldFont || '黑体'}`, // 默认黑体 包括 ('宋体','楷体','黑体','隶书','微软雅黑等字体'}
		lineHeight: `${config.fieldFontSize || 16}px`,
	};
	return style;
};

export const templateCode = [
	{
		path: '/xg/xg_hard/SearchAndPrint/printReview',
		code: 'award',
		name: '评奖评优奖状',
	},
	{
		path: '/xg/student_affairs/replace/printStudentCard',
		code: 'reissueStudentCard',
		name: '学生证补办打印',
	},
	{
		path: '/xg/stundents_record/printStudentCard',
		code: 'studentCard',
		name: '学生信息-学生证打印',
	},
	{
		path: '/jy/paiqian/biye/printSome',
		code: 'studentDispatch', // 宝鸡派遣报到证 打印
		name: '就业报到证',
	},
];
