/**
 * 钟是志
 * 2020年5月25日 18:03:24
 * 一站式请勿使用此组件
 * 拖拽配置 打印数据页面
 * 用于中医大评奖评优 奖状打印
 * 后续可以会应用于其他学校的其他 打印.
 * */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import DragSetting from './DragSetting';
import Shell from '@/baseComponent/Shell';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import { message } from 'antd';
import { saveConfig, queryConfig } from './services';

export default class Index extends Component {
	constructor(props) {
		super(props);
		this.state = {
			configAll: null,
		};
		this.getConfigInfo = queryConfig.bind(this);
	}

	updateConfig = ({ id, x, y }) => {
		const { configAll } = this.state;
		for (const item of configAll.config) {
			if (item.id + '' === id) {
				item.x = x;
				item.y = y;
			}
		}
		this.setState({
			configAll,
		});
	};

	saveConfig = () => {
		const {
			configAll: { config },
		} = this.state;
		saveConfig({
			contentStr: JSON.stringify(config),
		}).then((x) => {
			if (x) {
				message.success('保存成功');
			}
		});
	};

	componentDidMount() {
		this.getConfigInfo();
	}

	render() {
		const { configAll } = this.state;
		if (!configAll || !configAll.backgroundUrl) {
			return null;
		}
		// console.log(configAll);
		return (
			<Shell styleShell={{ marginTop: '0', marginBottom: '20px' }}>
				<div style={{ height: '54px', padding: '12px 0 24px 12px' }}>
					<ButtonDiy name="保存" className="primary" handleClick={this.saveConfig} />
				</div>
				<DragSetting
					backgroundUrl={configAll.backgroundUrl}
					updateConfig={this.updateConfig}
					configAll={configAll}
				/>
			</Shell>
		);
	}
}

Index.propTypes = {
	code: PropTypes.string.isRequired, //  后端配置的表里面的code 用于获取所有的配置项
};

Index.defaultProps = {
	code: 'award',
};
