import { getInfo } from '@/highOrderComponent/Service';

export function getConfigApi(code) {
	return getInfo({ code }, '/PublicPrintApi/query');
}

export const queryConfig = function() {
	const { code } = this.props;
	return getConfigApi(code).then((x) => {
		if (!x) {
			console.error('配置接口报错');
			return false;
		}
		if (x) {
			if (!x.backgroundUrl) {
				console.error('未配置打印背景图 无法进行操作');
				return false;
			}
			x.config = x.config.filter((y) => {
				// 过滤不显示的字段.
				return y.hasHidden !== true;
			});
			if (!x.config.length) {
				console.error('没有有效的配置项');
				return false;
			}
			this.setState({
				configAll: x,
			});
			return x;
		}
	});
};

export function saveConfig(parmas = {}) {
	return getInfo(parmas, '/PublicPrintApi/update');
}
