/**
 * 钟是志
 * 2019年3月29日
 * 一个年份加上校区-学院-专业的树
 * */

import { Input, Tree } from 'antd';
import React, { Component, Fragment } from 'react';
import Shell from '@/baseComponent/Shell';
import { getAppTypeList, getListByTreeList } from '@/webPublic/Services';
import { connect } from 'dva';
import { deepCopy } from '@/webPublic/zyd_public/utils/utils';
import BlockTitle from '@/baseComponent/BlockTitle';

const { TreeNode } = Tree;

export default class AppTypeTree extends Component {
	constructor() {
		super();
		this.state = {
			treeListData: [],
			name: '',
		};
	}

	handleChange = (newSearch) => {
		this.props.changeSearch(newSearch);
	};

	pushChildrenData = (treeListData, data, parentId) => {
		for (let item of treeListData) {
			if (item.id === parentId) {
				item.children = data;
				this.setState({
					treeListData: deepCopy(treeListData),
				});
				break;
			} else if (item.children && item.children.length) {
				this.pushChildrenData(item.children, data, parentId);
			}
		}
	};

	getLeafData = (parentId) => {
		const { groupId } = this.props;
		if (!groupId) {
			return null;
		}
		getListByTreeList({
			parentId,
			groupId,
			cacheKey: Math.random(),
		}).then((res) => {
			for (let item of res) {
				if (!item.isLeaf) {
					this.getLeafData(item.id);
				}
			}
			if (res.length) {
				this.pushChildrenData(this.state.treeListData, res, parentId);
			}
		});
	};

	getList = (name = null) => {
		const { groupId } = this.props;
		const { parentId } = this.state;
		if (!groupId) {
			return null;
		}
		getListByTreeList({
			parentId,
			groupId,
			name,
			cacheKey: Math.random(),
		}).then((treeListData) => {
			if (!treeListData || !treeListData.length) {
				this.setState({
					treeListData: [],
					loading: false,
				});
				this.handleChange({
					selectKey: '',
				});
			} else {
				for (let item of treeListData) {
					if (!item.isLeaf) {
						this.getLeafData(item.id);
					}
				}
				this.handleChange({
					selectKey: treeListData[0].id + '',
				});
				this.setState({
					treeListData,
					loading: false,
				});
			}
		});
		setTimeout(() => {
			if (document.getElementById('list-table-dom')) {
				let tableDom = document.getElementById('list-table-dom');
				this.setState({
					heightSet:
						document.body.clientHeight - 150 > tableDom.offsetHeight + 164
							? document.body.clientHeight - 150
							: tableDom.offsetHeight + 164,
				});
			}
		}, 1000);
	};

	componentDidMount() {
		this.getList();
	}

	componentDidUpdate(prevProps, prevState) {
		if (prevProps.groupId !== this.props.groupId) {
			this.getList();
		}
	}

	onSelect = (selectedKeys, info) => {
		this.handleChange({
			year: this.props.year,
			selectKey: selectedKeys[0],
		});
	};

	treeNodeList = (data) => {
		let dom = data.map((item) => {
			return (
				<TreeNode title={item.title} isLeaf={item.isLeaf} key={item.id}>
					{item.children && this.treeNodeList(item.children)}
				</TreeNode>
			);
		});
		return dom;
	};

	inputList = () => {
		const { name } = this.state;
		return (
			<Input.Search
				placeholder={'应用名称搜索'}
				onSearch={(value) => {
					this.getList(value);
				}}
				style={{ marginLeft: '10px', width: '150px' }}
			/>
		);
	};

	render() {
		const { treeListData, loading, heightSet } = this.state;
		const { selectKey } = this.props;
		return (
			<Fragment>
				<Shell
					styleShell={{
						borderRight: '1px solid rgba(210,210,210,1)',
						minHeight: heightSet || document.body.clientHeight - 150,
						backgroundColor: '#fff',
						overflowX: 'auto',
						marginTop: 0,
					}}>
					<BlockTitle title={'应用'} isSmall={true} dom={this.inputList()} />
					<Tree
						onSelect={this.onSelect}
						selectedKeys={[selectKey]}
						style={{ minHeight: '400px,' }}
						disabled={loading}>
						{this.treeNodeList(treeListData)}
					</Tree>
				</Shell>
			</Fragment>
		);
	}
}
