import React from 'react';
import { Select, Input, InputNumber, Button, DatePicker } from 'antd';
import { connect } from 'dva';
import moment from 'moment';
import ButtonDiy from '@/baseComponent/ButtonDiy';

const Option = Select.Option;

export default class QueryItem extends React.Component {
	constructor(props) {
		super(props);
		const value = props.value || {};
		this.state = {
			stringX: value.stringX, // 等于 不等于 那个下拉框的值
			string: value.string, // 搜索值
			disabled: value.disabled || false,
		};
	}

	componentWillReceiveProps(nextProps) {
		// Should be a controlled component.
		if ('value' in nextProps && nextProps.value) {
			const value = nextProps.value;
			this.setState({
				stringX: value.stringX, // 等于 不等于 那个下拉框的值
				string: value.string, // 搜索值
				disabled: value.disabled || false,
			});
		}
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			const newValue = Object.assign({}, this.state, changedValue);
			onChange(newValue);
		}
	};

	changeNumber = (e) => {
		if (!('value' in this.props)) {
			this.setState({ string: e });
		}
		this.triggerChange({ string: e });
	};
	changeStringX = (e) => {
		var disabled = false;

		if (e == 'IS NOT NULL' || e == 'IS NULL') {
			disabled = true;
		}
		if (!('value' in this.props)) {
			this.setState({ stringX: e, disabled });
		}

		this.triggerChange({ stringX: e, disabled });
	};
	changeString = (e) => {
		if (!('value' in this.props)) {
			this.setState({ string: e.target.value });
		}
		this.triggerChange({ string: e.target.value });
	};
	changeDate = (date) => {
		if (!('value' in this.props)) {
			this.setState({ string: date.valueOf() });
		}
		this.triggerChange({ string: date.valueOf() });
	};

	render() {
		const { obj } = this.props;
		const { string, stringX, disabled } = this.state;
		if (obj.options && obj.options.length > 0) {
			return (
				<div>
					<Select
						onChange={this.changeStringX}
						value={stringX || '='}
						style={{ width: 100, paddingRight: 12 }}>
						<Option value="=">等于</Option>
						<Option value="<>">不等于</Option>
						<Option value="IS NOT NULL">不为空</Option>
						<Option value="IS NULL">为空</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ paddingRight: 12 }}>
							<Select onChange={this.changeNumber} value={string} style={{ width: 200 }}>
								{obj.options.map((r) => (
									<Option key={r.v} value={r.v}>
										{r.l}
									</Option>
								))}
							</Select>
						</span>
					)}
					<ButtonDiy className="defaultRed" name="删除" handleClick={this.props.deleteQuery} />
				</div>
			);
		}
		if (obj.type === 'java.lang.String') {
			return (
				<div>
					<Select
						onChange={this.changeStringX}
						value={stringX || '='}
						style={{ width: 100, paddingRight: 12 }}>
						<Option value="=">等于</Option>
						<Option value="!=">不等于</Option>
						<Option value="like">像</Option>
						<Option value="IS NOT NULL">不为空</Option>
						<Option value="IS NULL">为空</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ paddingRight: 12 }}>
							<Input
								onChange={this.changeString}
								placeholder="请输入"
								value={string}
								style={{ width: 200 }}
							/>
						</span>
					)}
					<ButtonDiy className="defaultRed" name="删除" handleClick={this.props.deleteQuery} />
				</div>
			);
		} else if (
			obj.type === 'java.lang.Integer' ||
			obj.type === 'java.lang.Double' ||
			obj.type === 'java.lang.Long'
		) {
			return (
				<div>
					<Select
						onChange={this.changeStringX}
						value={stringX || '='}
						style={{ width: 100, paddingRight: 12 }}>
						<Option value="=">等于</Option>
						<Option value="<>">不等于</Option>
						<Option value=">">大于</Option>
						<Option value=">=">大于等于</Option>
						<Option value="<">小于</Option>
						<Option value="<=">小于等于</Option>
						<Option value="IS NOT NULL">不为空</Option>
						<Option value="IS NULL">为空</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ paddingRight: 12 }}>
							<InputNumber
								onChange={this.changeNumber}
								placeholder="请输入"
								value={string}
								style={{ width: 200 }}
							/>
						</span>
					)}
					<ButtonDiy
						className="defaultRed"
						style={{ marginLeft: 12 }}
						name="删除"
						handleClick={this.props.deleteQuery}
					/>
				</div>
			);
		} else if (obj.type === 'java.lang.Boolean') {
			return (
				<div>
					<Select
						onChange={this.changeStringX}
						value={stringX || '='}
						style={{ width: 100, paddingRight: 12 }}>
						<Option value="=">等于</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ paddingRight: 12 }}>
							<Select onChange={this.changeNumber} value={string} style={{ width: 200 }}>
								<Option value={true}>是</Option>
								<Option value={false}>否</Option>
							</Select>
						</span>
					)}
					<ButtonDiy
						className="defaultRed"
						style={{ marginLeft: 12 }}
						name="删除"
						handleClick={this.props.deleteQuery}
					/>
				</div>
			);
		} else if (obj.type === 'java.util.Date') {
			return (
				<div>
					<Select
						onChange={this.changeStringX}
						value={stringX || '='}
						style={{ width: 100, paddingRight: 12 }}>
						<Option value="=">等于</Option>
						<Option value="<>">不等于</Option>
						<Option value=">">大于</Option>
						<Option value=">=">大于等于</Option>
						<Option value="<">小于</Option>
						<Option value="<=">小于等于</Option>
						<Option value="IS NOT NULL">不为空</Option>
						<Option value="IS NULL">为空</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ paddingRight: 12 }}>
							<DatePicker
								onChange={this.changeDate}
								showTime
								format="YYYY-MM-DD HH:mm:ss"
								allowClear={false}
								style={{ width: 200 }}
								value={string ? moment(string) : null}
							/>
						</span>
					)}
					<ButtonDiy
						className="defaultRed"
						style={{ marginLeft: 12 }}
						name="删除"
						handleClick={this.props.deleteQuery}
					/>
				</div>
			);
		} else {
			return <span>暂无法处理</span>;
		}
	}
}
