// https://www.wangeditor.com/v4/pages/02-%E5%86%85%E5%AE%B9%E5%A4%84%E7%90%86/02-%E8%BF%BD%E5%8A%A0%E6%96%B0%E5%86%85%E5%AE%B9.html
import Editor from '@/webPublic/zyd_public/WangEditor/includes/wangEditor.min';
import { message } from 'antd';
import {
  uploadFile,
  uploadWordToHtml
} from "@/webPublic/one_stop_public/libs/PictureSignature/ShowItem";
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';

const E = Editor;
const { BtnMenu } = E;
window.message = message;
/**
 * 提取HTML标签内的内容
 *
 * @param {*} html
 * @param {标签} tag
 * @return {*} 
 */
function extractBodyContent(html, tag) {
  // 使用正则表达式匹配<body>标签内的内容
  // 注意：这个正则表达式假设<body>标签内不会嵌套另一个<html>或<head>等标签
  // 这种情况在正常的HTML文档中几乎不会发生
  let regex;
  if (tag === 'body') {
    regex = /<body[^>]*>([\s\S]*?)<\/body>/i;
  }
  if (tag === 'style') {
    regex = /<style[^>]*>([\s\S]*?)<\/style>/i;
  }
  const match = html.match(regex);

  if (match && match.length > 1) {
      // 返回<body>标签内的内容
      return match[1];
  } else {
      // 如果没有找到<body>标签，则返回空字符串
      return '';
  }
}

export default class WordMenu extends BtnMenu {
  constructor(editor) {
    // data-title属性表示当鼠标悬停在该按钮上时提示该按钮的功能简述
    const $elem = E.$(
      `<div class='w-e-menu' data-title='Alert' style='position: relative;' title="导入word">
      <svg style="width: 20px;" viewBox="0 0 20 20" title="导入word">
      <path d="m14 0 5 4.5v8.892l-1.5-1.8V6.5h-5v-5h-8v3H3V0h11Zm0 2v3h3.3L14 2Z"></path><path d="M10.74 18a2.76 2.76 0 0 1-.469-.5H3V19h9.25v-.374A2.737 2.737 0 0 1 10.74 18Z"></path><path d="M8.5 6a1.5 1.5 0 0 1 1.493 1.356L10 7.5v7a1.5 1.5 0 0 1-1.356 1.493L8.5 16h-7a1.5 1.5 0 0 1-1.493-1.356L0 14.5v-7a1.5 1.5 0 0 1 1.356-1.493L1.5 6h7ZM7.483 8.795l-.042.088-.986 2.534-.947-2.528-.043-.092a.601.601 0 0 0-1.042.008l-.042.093-.883 2.465-.937-2.475-.042-.089a.6.6 0 0 0-1.107.42l.027.093 1.514 4 .044.092a.6.6 0 0 0 1.041-.01l.041-.092.88-2.458.925 2.467.046.096a.602.602 0 0 0 1.032 0l.043-.09 1.554-4 .028-.093a.6.6 0 0 0-1.104-.43v.001ZM11.674 15.407a.75.75 0 1 0 1.152.96L14 14.96V20h1.5v-5.04l1.174 1.408a.75.75 0 1 0 1.152-.96l-2.346-2.816a.95.95 0 0 0-1.46 0l-2.346 2.815Z"></path>
      </svg>
      </div>`,
    );
    super($elem, editor);
  }

  // 菜单点击事件
  clickHandler() {
    // 做任何你想做的事情
    // 可参考【常用 API】文档，来操作编辑器
    let dom = document.createElement('input');
    dom.accept = 'application/msword, application/vnd.openxmlformats-officedocument.wordprocessingml.document';
    dom.type = 'file';
    dom.onchange = (v) => {
      if (dom.files && dom.files.length) {
        window.message.info('正在上传文件, 请耐心等待');
        this.editor.disable();

        const file = dom.files[0];
        const fileName = file.name;
        uploadWordToHtml(file)
          .then((res) => {
            setTimeout(() => {
              if (res && res.html) {
                this.editor.enable();
                window.message.success('上传文件成功');
                // 30354 【移动端】家庭经济困难学生认定,手机端这么搞，已通过项目组审核
                // 将 embed 改完iframe 解决移动端不显示pdf 文件的bug
                const styleStr = extractBodyContent(res.html, 'style');
                const newStyleStr = `<style type="text/css">.selfEditor ${styleStr.replace(/\}/g, '} .selfEditor')}</style>`;
                const bodyStr = extractBodyContent(res.html, 'body');
                const newHtml = `<div>${newStyleStr}<div class='selfEditor'> ${bodyStr} </div></div>`;
                this.editor.txt.append(newHtml);
              }
            }, 2000);

          }).catch((err) => {
            this.editor.enable();
            window.message.error('上传文件失败');
          });
      }
    };
    dom.click();
  }

  // 菜单是否被激活（如果不需要，这个函数可以空着）
  // 1. 激活是什么？光标放在一段加粗、下划线的文本时，菜单栏里的 B 和 U 被激活，如下图
  // 2. 什么时候执行这个函数？每次编辑器区域的选区变化（如鼠标操作、键盘操作等），都会触发各个菜单的 tryChangeActive 函数，重新计算菜单的激活状态
  tryChangeActive() {
    // 激活菜单
    // 1. 菜单 DOM 节点会增加一个 .w-e-active 的 css class
    // 2. this.this.isActive === true
    this.active();

    // // 取消激活菜单
    // // 1. 菜单 DOM 节点会删掉 .w-e-active
    // // 2. this.this.isActive === false
    // this.unActive()
  }
}
