// 钟是志
// 2022年5月10日
//压缩图片函数
// 超过2兆的图片按比例压缩 TODO 尽量保证压缩后的图片接近2MB大小.

export default function(file, callBack) {
  // 有损压缩
  let fileSizeMb = file.size / 1024 / 1024;
  let fileName = file.name;
  if (fileSizeMb < 2) {  // 2MB 以下的图片不需要压缩。
    callBack(file);
    return;
  }
  let reader = new FileReader();
  reader.readAsDataURL(file);
  reader.onload = (e) => {
    //这里的e.target.result就是转换后base64格式的图片文件
    let image = new Image(); //新建一个img标签（还没嵌入DOM节点)
    image.src = e.target.result;
    image.onload = () => {
      let canvas = document.createElement('canvas');
      let context = canvas.getContext('2d');
      let imageWidth = image.width * (2 / fileSizeMb);    // 超过2兆的图片 按比例压缩
      let imageHeight = image.height * (2 / fileSizeMb); // 超过2兆的图片 按比例压缩
      let data = '';
      canvas.width = imageWidth;
      canvas.height = imageHeight;
      context.drawImage(image, 0, 0, imageWidth, imageHeight);
      data = canvas.toDataURL('image/jpeg');
      const dataURLtoFile = (dataurl, filename) => {//将base64转换为文件
        let arr = dataurl.split(',');
        let mime = arr[0].match(/:(.*?);/)[1];

        let bstr = atob(arr[1]);
        let n = bstr.length;
        let u8arr = new Uint8Array(n);
        while (n--) {
          u8arr[n] = bstr.charCodeAt(n);
        }
        return new File([u8arr], filename, { type: mime });
      };
      let newFile = dataURLtoFile(data, fileName);
      newFile.uid = file.uid;
      callBack(newFile);
      //压缩完成
    };
  };
};
