import React from 'react';
import { Tooltip } from 'antd';


export const RenderLongText = (title = '') => {
  if (!title) {
    return '';
  }
  const oldTitle = title;
  if (title.length > 8) {
    const newTitle = title.slice(0, 8) + '...';
    title = newTitle;
    return (
      <Tooltip
        title={oldTitle}
        key={oldTitle}
      >
                <span
                  key={title}
                >
                  {title}
                </span>
      </Tooltip>

    );
  } else {
    return title;
  }
};

export const RenderLongText2 = (title = '', widthAuto = 8) => {
  if(typeof widthAuto !== 'number'){
    widthAuto = 8;
  }
  if (!title) {
    return '';
  }
  const oldTitle = title;
  if (title.length > widthAuto) {
    const newTitle = title.slice(0, widthAuto) + '...';
    title = newTitle;
    return (
      <Tooltip
        title={oldTitle}
        key={oldTitle}
      >
                <span
                  key={title}
                >
                  {title}
                </span>
      </Tooltip>

    );
  } else {
    return title;
  }
};
