/**
 * 钟是志
 * 2021年5月9日 10:50:02
 * 重构拖拽字段组件old.js. 适用于宝鸡录取通知书打印
 * */
import React, { Fragment, Component, useRef, useState, useEffect } from 'react';
import styles from './index.less';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import Shell from '@/baseComponent/Shell';
import { ModalConfirm } from '@/baseComponent/Modal';

let time1 = new Date().getTime();

export default function NewDraggableSetting(props) {
	const {
		bgImage, // 背景图url 字符串
		formatSettingObject, // 字段配置信息 数组
		saveConfig, // 保存 方法
		initConfig, // 初始化配置项 方法
		updateFormatSettingObject, // 更新格式化 方法
		id, //  'printDom' 字符串
	} = props;
	const [drag, setDrag] = useState({
		objX: '0px',
		objY: '0px',
		mouseY: 0,
		mouseX: 0,
	});
	const [isDownObj, setIsDownObj] = useState({});

	const configInfo = Object.keys(formatSettingObject);

	function initInfoThis() {
		ModalConfirm('您确定初始化打印录取通知书格式吗?', {
			onOk: () => {
				initConfig();
			},
		});
	}

	function handleOnMouseDown(e) {
		// 鼠标按钮 按下
		const id = e.target.id;
		const div = document.getElementById(id);
		const newDrag = {
			objX: div.style.left,
			objY: div.style.top,
			mouseX: e.clientX,
			mouseY: e.clientY,
		};
		for (let item in isDownObj) {
			isDownObj[item] = false;
		}
		isDownObj[id] = true;
		setDrag(newDrag);
		setIsDownObj(isDownObj);
	}

	function handleOnMouseUp(e) {
		// 鼠标 按钮 收起 更新数据到props
		const id = e.target.id;
		let { mouseX, mouseY, objX, objY } = drag;
		if (isDownObj[id]) {
			let x = e.clientX;
			let y = e.clientY;
			let div = document.getElementById(id);
			const styleLeft = parseInt(x, 10) - parseInt(mouseX, 10) + parseInt(objX, 10);
			const styleTop = parseInt(y, 10) - parseInt(mouseY, 10) + parseInt(objY, 10);
			div.style.left = `${styleLeft}px`;
			div.style.top = `${styleTop}px`;
			mouseX = x;
			mouseY = y;
			updateFormatSettingObject(id, styleLeft, styleTop); // 更新 偏移量 left  top 和 元素
			setDrag({
				mouseX,
				mouseY,
				objX,
				objY,
			});
			setIsDownObj({});
		}
	}

	function handleOnMouseMove(e) {
		// 鼠标 移动
		if (new Date().getTime() - time1 < 17) {
			// 每17毫秒进行一次移动的计算.
			time1 = new Date().getTime();
			return false;
		}
		let id = '';
		for (let item in isDownObj) {
			if (isDownObj[item]) {
				id = item;
			}
		}
		if (!id) {
			return false;
		}

		let { mouseX, mouseY, objX, objY } = drag;
		const div = document.getElementById(id);
		let x = e.clientX;
		let y = e.clientY;
		if (isDownObj && isDownObj[id]) {
			const styleLeft = parseInt(objX, 10) + parseInt(x, 10) - parseInt(mouseX, 10); // 计算偏移量
			const styleTop = parseInt(objY, 10) + parseInt(y, 10) - parseInt(mouseY, 10); // 计算偏移量
			const dropZone = document.getElementById('dropZone');
			if (
				// 阻止拖拽到图片外部
				styleLeft > dropZone.width - 50 ||
				styleLeft < 15 ||
				styleTop > dropZone.height - 50 ||
				styleTop < 15
			) {
				console.error('拖拽到了图片区域外部,不能进行拖拽');
				return false;
			}
			div.style.left = styleLeft + 'px';
			div.style.top = styleTop + 'px';
		}
	}
	return (
		<Fragment>
			<Shell
				styleShell={{
					marginTop: '0',
					marginBottom: '20px',
				}}>
				<div
					style={{
						height: '54px',
						padding: '12px 0 12px 12px',
					}}>
					<ButtonDiy name="保存" className="primary" handleClick={saveConfig} />
					<ButtonDiy name={'初始化格式'} handleClick={initInfoThis} />
				</div>
			</Shell>
			<div className={styles.outSideDiv} onMouseMove={handleOnMouseMove}>
				<div>
					<img
						src={bgImage}
						id={'dropZone'}
						draggable={false}
						className={styles.bgimage}
						alt={'背景图'}
					/>
					{configInfo.map((x) => {
						return (
							<div
								className={styles.inSideItem}
								key={x}
								onMouseDown={handleOnMouseDown}
								onMouseUp={handleOnMouseUp}
								id={x}
								style={formatSettingObject[x].style}>
								{formatSettingObject[x].title}
							</div>
						);
					})}
				</div>
			</div>
		</Fragment>
	);
}
