/**
 *
 * 一站式请勿使用此组件
 * 2020年5月9日 拖拽组件
 * 钟是志
 * 黔南的 录取通知书打印 位置设置
 * */

import React, { Fragment, Component } from 'react';
import styles from './index.less';
import { message } from 'antd';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import Shell from '@/baseComponent/Shell';
import { ModalConfirm } from '@/baseComponent/Modal';

let startX = 0;
let startY = 0;

export default class FormatSetting extends Component {
	constructor() {
		super();
		document.onmousedown = function(evt) {
			startX = evt.offsetX;
			startY = evt.offsetY;
		};
	}

	dragEventList = () => {
		const { updateFormatSettingObject } = this.props;
		let draggedRef = null;
		document.addEventListener(
			'dragstart',
			function(event) {
				// 保存拖动元素的引用(ref.)
				draggedRef = event.target;
				// 使其半透明
				event.target.style.opacity = 0.5;
			},
			false,
		);
		document.addEventListener(
			'dragend',
			function(event) {
				// 重置透明度
				event.target.style.opacity = '';
			},
			false,
		);

		/* 放下目标节点时触发事件 */
		document.addEventListener(
			'dragover',
			function(event) {
				// 阻止默认动作
				event.preventDefault();
			},
			false,
		);
		document.addEventListener(
			'drop',
			function(event) {
				// 阻止默认动作（如打开一些元素的链接）
				event.preventDefault();
				// 将拖动的元素到所选择的放置目标节点中

				let infoClientRect = document.getElementById('dropZone').getBoundingClientRect();
				let leftNew = Math.ceil(event.clientX - infoClientRect.left) - startX;
				let topNew = Math.ceil(event.clientY - infoClientRect.top) - startY;

				if (
					leftNew < 0 ||
					leftNew > infoClientRect.width ||
					topNew < 0 ||
					topNew > infoClientRect.height
				) {
					message.warn('拖拽到了图片区域外部!');
					return false;
				} else {
				}

				if (event.target.id === 'dropZone') {
					// const left = event.offsetX;
					// const top = event.offsetY;
					updateFormatSettingObject(draggedRef.id, leftNew, topNew);
					draggedRef.style.left = leftNew; // `${left}px`;
					draggedRef.style.top = topNew; // `${top}px`;
				}
			},
			false,
		);
	};

	componentDidMount() {
		this.dragEventList();
	}

	initConfig = () => {
		ModalConfirm('您确定初始化打印录取通知书格式吗?', {
			onOk: () => {
				this.props.initConfig();
			},
		});
	};

	render() {
		const { bgImage, formatSettingObject, saveConfig, pageConfiguration } = this.props;
    let bgImageStyle = {};
    if(pageConfiguration && pageConfiguration.width){
      bgImageStyle.width = pageConfiguration.width + 'cm';
      bgImageStyle.height = pageConfiguration.height + 'cm';
    }
		return (
			<Fragment>
				<Shell
					styleShell={{
						marginTop: '0',
						marginBottom: '20px',
					}}>
					<div
						style={{
							height: '54px',
							padding: '12px 0 12px 12px',
						}}>
						<ButtonDiy name="保存" className="primary" handleClick={saveConfig} />
						<ButtonDiy name={'初始化格式'} handleClick={this.initConfig} />
					</div>
				</Shell>
				<div className={styles.outSideDiv}>
					<div>
						<img
							src={bgImage}
							id={'dropZone'}
							draggable={false}
              style={bgImageStyle}
              className={styles.bgimage}
							alt={'背景图'}
						/>
						{formatSettingObject.map((x, index) => {
							return (
								<div
									draggable={true}
									className={styles.inSideItem}
									key={index}
									id={x.name + ''}
									style={x.style}>
									{x.name}
								</div>
							);
						})}
					</div>
				</div>
			</Fragment>
		);
	}
}
/***
 * formatSettingObject: {
 *   content_set:  {
 *     font: "宋体"
       isNeedConfig: true
       key: "JjqCiRYamxs"
       name: "content_set"
       size: "12"
       style: {top: 300, left: 50}
       title: "--详细内容--"
 *   }
 * }
 *
 * */
