import { getToken } from '@/utils/authority';
import { getHeaders } from '@/webPublic/zyd_public/utils/getHeaders';
import { getIsBei_Dian } from '@/webPublic/zyd_public/utils/getSchoolType';

const token = getToken();
export default function fetchJSON(url, body) {
	if (url.indexOf('token=') <= -1 && !getIsBei_Dian()) {
		url = url + '?token=' + token;
	}
	return fetch(url, {
		method: 'post',
		body: JSON.stringify(body),
    credentials: 'include', // 确保浏览器不在请求中包含凭据 // 用这个本地访问北电科会跨域
    mode: 'cors',
		headers: {
			'Content-Type': 'application/json',
			Accept: 'application/json',
			...getHeaders(url).headers,
		},
	})
		.then(function(res) {
			return res.json();
		})
		.then(function(data) {
			console.log(data);
			return data;
		});
}
