import urlTransform from '@/webPublic/zyd_public/request/urlTransform';
import FormdataWrapper from '@/webPublic/zyd_public/utils/object-to-formdata-custom';
import { notification } from 'antd';
import { getHeaders } from '@/webPublic/zyd_public/utils/utils';


/**
 * 本地开发可能会存在跨域问题
 * 只能用于学工的接口的下载文件
 * 2022年7月8日
 * 如果ext 传空字符串 则从response.headers 中获取文件名
 * */
export function downloadFile(
	url,
	params,
	fileName = '导出文件',
	ext = 'xlsx',
	method = 'POST',
) {
	url = urlTransform(url);

	let responseHeadersFileName = '';

	fetch(url, {
		method,
		body: method === 'GET' ? undefined : FormdataWrapper(params),
		...getHeaders(),
	})
		.then((res) => {
			if (res.status + '' !== '200') {
				return res.json();
			} else {
				const contentDisposition = res.headers.get('content-disposition');
				let fileNameEncode =
					contentDisposition && contentDisposition.split('filename=');
				if (fileNameEncode && fileNameEncode.length > 1) {
					fileNameEncode = fileNameEncode[1];
					responseHeadersFileName = decodeURIComponent(escape(fileNameEncode));
					// https://blog.csdn.net/erdfty/article/details/106134284
				}
				// 解码
				return res.blob();
			}
		})
		.then((data) => {
			if (data instanceof Blob) {
				let a = document.createElement('a');
				url = window.URL.createObjectURL(data);
				a.href = url;
				a.download = !ext ? responseHeadersFileName : fileName + '.' + ext; // 如果传入的ext 为空字符串(不等于不传) 则使用响应头中的文件作为文件名
				a.click();
				window.URL.revokeObjectURL(url);
				a = null;
			} else {
				notification.error({
					message: `文件导出错误`,
					description: data.errMsg,
				});
			}
		})
		.catch((err) => {
			console.log(err);
			notification.error({
				message: `网络请求超时`,
			});
		})
		.finally(() => {
			return true;
		});
}
