import { downloadFile, getIsBei_Dian } from '@/webPublic/zyd_public/utils/utils';
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import { getInfo, transformApi } from '@/highOrderComponent/Service';
import urlTransform from '@/webPublic/zyd_public/request/urlTransform';

export function hrefWithToken(
	url,
	arg = {
		justOpenUrl: false,
		params: {},
		fileName: '导出',
		method: 'GET',
		ext: 'xlsx',
		prexUrl: '',
	},
) {
	const { justOpenUrl, params, fileName, method, ext, prexUrl } = arg;
	if (!getIsBei_Dian() && method !== 'POST') {
		if (url.indexOf('?') > -1) {
			url = `${url}&token=${getToken()}`;
		} else {
			url = `${url}?token=${getToken()}`;
		}
	}
	const hrefUrl = prexUrl ? prexUrl : transformApi(url);
	let u = `${hrefUrl}${url}`;
	u = urlTransform(u);
	if (justOpenUrl) {
		window.open(u);
	}
	console.log('hrefWithToken', u);
	if (getIsBei_Dian() || method === 'POST') {
		// 这里如果换成POST请求 会需要小心接口报错
		downloadFile(u, params, fileName, ext, method);
		// downloadFile(u, {}, '', '', 'GET');
		return;
	}

	getInfo({}, '/InstructorConfigApi/getCurrentDate').then((response) => {
		if (response) {
			window.open(`${u}`); // 存在问题 浏览器会自动切换内核到IE 内核导致 文件名称乱码.
			return true;
		} else {
			return false;
		}
	});
}

export function hrefWithTokenSg(url = '', arg = {}) {
	return hrefWithToken(url, arg);
}
