import request from '@/webPublic/zyd_public/request/request';
import { getCurrentUser, getToken } from '@/webPublic/one_stop_public/utils/token';

export const getTime = () => {
  const config = window.specialImportantSystemConfig || {};
  if (config.mockServer) {
    return request(
      `${config.mockServer}/${config.gateWayUrl.zydxg}/InstructorConfigApi/getCurrentDate`,
      {
        method: 'POST',
        body: {},
      },
    ).then(t => {
      if (t) {
        return t - new Date().getTime(); // 服务器时间 与 客户端时间的差值;
      } else {
        return 0;
      }
    });
  } else {
    return new Promise(resolve => {
      resolve(0);
      return 0;
    });
  }
};

export async function queryCurrent() {
  const config = window.specialImportantSystemConfig || {};
  let token = getToken();
  let userInfo = getCurrentUser();
  if (token && userInfo.token === token) {
    return new Promise(resolve => {
      resolve(userInfo);
      return userInfo;
    });
  }
  if (config.mockServer) {
    return request(`${config.mockServer}/${config.gateWayUrl.zydxg}/UserApi/queryCurrent`, {
      method: 'POST',
      body: {},
    });
  }
}
